package cn.com.duiba.kjy.api.api.remoteservice.menu;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.response.BaseResponse;
import cn.com.duiba.kjy.api.api.dto.response.menu.ConditionalTryMatchResponse;
import cn.com.duiba.kjy.api.api.dto.response.menu.CreateConditionalMenuResponse;
import cn.com.duiba.kjy.api.api.dto.response.menu.GetAllMenuResponse;
import cn.com.duiba.kjy.api.api.param.WxBaseParam;
import cn.com.duiba.kjy.api.api.param.menu.ConditionalTryMatchParam;
import cn.com.duiba.kjy.api.api.param.menu.CreateConditionalMenuParam;
import cn.com.duiba.kjy.api.api.param.menu.CreateDefaultMenuParam;
import cn.com.duiba.kjy.api.api.param.menu.DeleteConditionalMenuParam;

/**
 * 公众号菜单管理
 * @author lizhi
 * @date 2020/10/9 11:16 AM
 */
@AdvancedFeignClient
public interface RemoteWxMenuService {

    /**
     * 创建默认菜单
     * @param param 创建默认菜单参数
     * @return 是否成功
     */
    BaseResponse createDefaultMenu(CreateDefaultMenuParam param);

    /**
     * 创建个性化菜单
     * @param param 创建个性化菜单参数
     * @return 菜单ID
     */
    CreateConditionalMenuResponse createConditionalMenu(CreateConditionalMenuParam param);

    /**
     * 删除个性化菜单
     * @param param 删除个性化菜单参数
     * @return 是否成功
     */
    BaseResponse deleteConditionalMenu(DeleteConditionalMenuParam param);

    /**
     * 获取公众号所有菜单
     * @param param 公众号ID
     * @return 菜单
     */
    GetAllMenuResponse getAllMenu(WxBaseParam param);

    /**
     * 测试个性化菜单匹配结果
     * @param param 用户openId
     * @return 用户当前菜单
     */
    ConditionalTryMatchResponse conditionalTryMatch(ConditionalTryMatchParam param);
}
