/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.api.dto.wxmessage.wrapper;

import cn.com.duiba.kjy.api.api.bean.MessageConfigErrorException;
import cn.com.duiba.kjy.api.api.dto.wxmessage.BaseMessageDto;
import cn.com.duiba.kjy.api.api.dto.wxmessage.MessageUserDto;
import cn.com.duiba.kjy.api.api.dto.wxmessage.innerlog.WxSendEmbedDto;
import cn.com.duiba.kjy.api.api.dto.wxmessage.template.TemplateMessageDto;
import cn.com.duiba.kjy.api.api.dto.wxmessage.wrapper.BatchWxMessageWrapperDto;
import cn.com.duiba.kjy.api.api.dto.wxmessage.wrapper.SingleWxMessageWrapperDto;
import cn.com.duiba.kjy.api.api.dto.wxmessage.wrapper.WxMessageWrapperDto;
import cn.com.duiba.kjy.api.api.enums.DegradedTypeEnum;
import cn.com.duiba.kjy.api.api.enums.MessageTypeEnum;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class WxMessageWrapperBuilder {
    private static final ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true).buildValidatorFactory();
    private static final Validator validator = validatorFactory.getValidator();
    private Integer messageType;
    @NotNull(message="\u6d88\u606f\u4f53\u4e0d\u80fd\u4e3a\u7a7a")
    private BaseMessageDto messageDto;
    @NotNull(message="\u63a5\u53d7\u6d88\u606f\u7684\u516c\u4f17\u53f7\u4e0d\u80fd\u4e3a\u7a7a")
    private Long oaId;
    private WxSendEmbedDto wxSendEmbedBean;
    @NotNull(message="\u964d\u7ea7\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a")
    private Integer degradedType = DegradedTypeEnum.DISCARD.getCode();
    private WxMessageWrapperDto degradedMessageWrapperDto;

    public WxMessageWrapperBuilder setOaId(Long oaId) {
        if (Objects.isNull(oaId) || oaId < 1L) {
            throw new MessageConfigErrorException("oaId \u975e\u6cd5");
        }
        this.oaId = oaId;
        return this;
    }

    public WxMessageWrapperBuilder setMessageDto(Integer messageType, BaseMessageDto messageDto) {
        MessageTypeEnum.getByCode(messageType);
        this.validatorBean(messageDto);
        this.messageType = messageType;
        this.messageDto = messageDto;
        return this;
    }

    public WxMessageWrapperBuilder setEmbedParam(String pushEventType, Map<String, Object> customMap) {
        WxSendEmbedDto wxSendEmbedDto;
        this.wxSendEmbedBean = wxSendEmbedDto = new WxSendEmbedDto(pushEventType, customMap);
        return this;
    }

    public WxMessageWrapperBuilder setDegradedMessage(WxMessageWrapperDto degradedMessageWrapperDto) {
        this.validatorBean(degradedMessageWrapperDto);
        degradedMessageWrapperDto.setDegradedType(DegradedTypeEnum.DISCARD.getCode());
        degradedMessageWrapperDto.setDegradedMessageWrapperDto(null);
        this.degradedType = DegradedTypeEnum.OTHER_MESSAGE.getCode();
        this.degradedMessageWrapperDto = degradedMessageWrapperDto;
        return this;
    }

    public WxMessageWrapperBuilder setDegradedTemplateMessage(TemplateMessageDto templateMessageDto, MessageUserDto messageUserDto) {
        this.validatorBean(templateMessageDto);
        SingleWxMessageWrapperDto degradedMessageWrapperDto = new SingleWxMessageWrapperDto();
        degradedMessageWrapperDto.setMessageType(MessageTypeEnum.TEMPLATE.getCode());
        degradedMessageWrapperDto.setMessageDto(templateMessageDto);
        degradedMessageWrapperDto.setDegradedType(DegradedTypeEnum.DISCARD.getCode());
        degradedMessageWrapperDto.setDegradedMessageWrapperDto(null);
        degradedMessageWrapperDto.setUser(messageUserDto);
        this.degradedType = DegradedTypeEnum.OTHER_MESSAGE.getCode();
        this.degradedMessageWrapperDto = degradedMessageWrapperDto;
        return this;
    }

    public BatchWxMessageWrapperDto createBatchMessage(List<MessageUserDto> userList) {
        BatchWxMessageWrapperDto batchWxMessageWrapperDto = new BatchWxMessageWrapperDto();
        batchWxMessageWrapperDto.setWxSendEmbedBean(this.wxSendEmbedBean);
        batchWxMessageWrapperDto.setMessageDto(this.messageDto);
        batchWxMessageWrapperDto.setOaId(this.oaId);
        batchWxMessageWrapperDto.setMessageType(this.messageType);
        batchWxMessageWrapperDto.setDegradedType(this.degradedType);
        batchWxMessageWrapperDto.setDegradedMessageWrapperDto(this.degradedMessageWrapperDto);
        batchWxMessageWrapperDto.setUserList(userList);
        this.validatorBean(batchWxMessageWrapperDto);
        return batchWxMessageWrapperDto;
    }

    public SingleWxMessageWrapperDto createSingleMessage(MessageUserDto user) {
        SingleWxMessageWrapperDto singleWxMessageWrapperDto = new SingleWxMessageWrapperDto();
        singleWxMessageWrapperDto.setWxSendEmbedBean(this.wxSendEmbedBean);
        singleWxMessageWrapperDto.setMessageDto(this.messageDto);
        singleWxMessageWrapperDto.setOaId(this.oaId);
        singleWxMessageWrapperDto.setMessageType(this.messageType);
        singleWxMessageWrapperDto.setDegradedType(this.degradedType);
        singleWxMessageWrapperDto.setDegradedMessageWrapperDto(this.degradedMessageWrapperDto);
        singleWxMessageWrapperDto.setUser(user);
        this.validatorBean(singleWxMessageWrapperDto);
        return singleWxMessageWrapperDto;
    }

    private <T> void validatorBean(T t) {
        Set validateResult = validator.validate(t, new Class[]{Default.class});
        if (CollectionUtils.isNotEmpty((Collection)validateResult)) {
            throw new MessageConfigErrorException(validateResult);
        }
    }
}

