package cn.com.duiba.kjy.api.api.dto.push;

import lombok.Data;

import java.io.Serializable;

/**
 * 代理人推送数据
 * @author lizhi
 * @date 2022/1/18 10:27 上午
 */
@Data
public class SellerPushDto implements Serializable {

    private static final long serialVersionUID = 230664566262087839L;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 用户的昵称
     */
    private String nickname;

    /**
     * 用户ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 销售员昵称
     */
    private String sellerName;

    /**
     * 渠道类型：1:个微公众号 2:企业应用 3:第三方APP
     * @see cn.com.duiba.kjy.base.api.enums.ProviderChannelEnum
     */
    private Integer channelType;

    /**
     * type=1时是公众号ID，type=2时是企微应用ID，type=3时是第三方appId
     */
    private Long channelBizId;

    /**
     * 推送的用户唯一标识
     */
    private String channelUserKey;

    /**
     * 企业微信的企业ID，仅企业微信用户有值
     */
    private Long workCorpId;
}
