package cn.com.duiba.kjy.api.api.dto.scheme;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

/**
 * 注意 生成31天（包含31）以上为长期有效的scheme码 是有生成上限次数的！！！
 * @author wangbinbin
 * @create 2021-02-06 16:40
 * @descript 微信外部链接请求dto
 */
@Data
public class WechatSchemeRequestDto implements Serializable {

    private static final long serialVersionUID = 2722946751678724938L;

    /**
     * 小程序id
     */
    @NotNull(message = "oaId不能为空")
    private Long oaId;

    /**
     * 小程序页面地址
     */
    @NotBlank(message = "小程序页面地址不能为空")
    private String pagePath;

    /**
     * 小程序请求参数
     */
    private String query;

    /**
     * 过期时间
     */
    private Integer timeUnitNumber;

    /**
     * 过期时间单位
     */
    private TimeUnit timeUnit;

    /**
     * 是否为过期的地址
     * 默认为true
     */
    private Boolean isExpired = true;

}
