package cn.com.duiba.kjy.api.api.dto.wxmessage.wxwork.messagepush.wrap;

import cn.com.duiba.kjy.api.api.bean.MessageConfigErrorException;
import cn.com.duiba.kjy.api.api.dto.wxmessage.innerlog.WxSendEmbedDto;
import cn.com.duiba.kjy.api.api.dto.wxmessage.wxwork.messagepush.WxWorkBaseMessageDto;
import cn.com.duiba.kjy.api.api.dto.wxmessage.wxwork.messagepush.WxWorkMessageUserDto;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.HibernateValidator;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author dugq
 * @date 2021/12/6 1:38 下午
 */
public class WxWorkSuiteMsgBuilder<T extends WxWorkBaseMessageDto> {

    private static final ValidatorFactory validatorFactory = Validation.byProvider( HibernateValidator.class )
            .configure()
            .failFast( true )
            .buildValidatorFactory();
    private static final Validator validator = validatorFactory.getValidator();

    /**
     * 消息体
     */
    protected T messageDto;

    /**
     * 优先选择user对象的oaID
     * 接受消息的目标公众号
     */
    @NotNull(message = "接受消息的应用不能为空")
    protected Long suitId;
    /**
     * 推送事件
     */
    protected WxSendEmbedDto wxSendEmbedBean;


    public WxWorkSuiteMsgBuilder<T> setSuiteId(Long suiteId){
        if (Objects.isNull(suiteId) || suiteId<1){
            throw new MessageConfigErrorException("应用ID非法");
        }
        this.suitId = suiteId;
        return this;
    }

    /**
     * 设置消息体。
     * @param messageType 消息类型
     * @param messageDto 消息体
     * @return
     */
    public WxWorkSuiteMsgBuilder<T> setMessageDto(T messageDto){
        validatorBean(messageDto);
        this.messageDto = messageDto;
        return this;
    }

    /**
     * 设置推送日志打印参数
     * @param pushEventType push_id，与BI沟通获取
     * @param customMap 其他需要记录的参数，没有填null
     * @return
     */
    public WxWorkSuiteMsgBuilder<T> setEmbedParam(String pushEventType, Map<String, Object> customMap){
        this.wxSendEmbedBean = new WxSendEmbedDto(pushEventType,customMap);
        return this;
    }

    public SingleWxWorkMessageWrapperDto<T> CreateSingleMessage(Long corpId,String userKey){
        WxWorkMessageUserDto wxWorkMessageUserDto = new WxWorkMessageUserDto();
        wxWorkMessageUserDto.setCorpId(corpId);
        wxWorkMessageUserDto.setUserKey(userKey);
        SingleWxWorkMessageWrapperDto<T> wxxMessageWrapperDto = new SingleWxWorkMessageWrapperDto<>();
        wxxMessageWrapperDto.setWxSendEmbedBean(wxSendEmbedBean);
        wxxMessageWrapperDto.setMessageDto(messageDto);
        wxxMessageWrapperDto.setSuiteId(suitId);
        wxxMessageWrapperDto.setUser(wxWorkMessageUserDto);
        validatorBean(wxxMessageWrapperDto);
        return wxxMessageWrapperDto;
    }



    /**
     * 构建批量消息体
     */
    public WxWorkMessageWrapperDto<T> createBachMessage(List<WxWorkMessageUserDto> userList){
        if (CollectionUtils.isEmpty(userList)){
            throw new MessageConfigErrorException("未指定推送的用户列表");
        }
        BatchWxWorkMessageWrapperDto<T> batchWxMessageWrapperDto = new BatchWxWorkMessageWrapperDto<>();
        batchWxMessageWrapperDto.setWxSendEmbedBean(wxSendEmbedBean);
        batchWxMessageWrapperDto.setMessageDto(messageDto);
        batchWxMessageWrapperDto.setSuiteId(suitId);
        batchWxMessageWrapperDto.setUserList(userList);
        validatorBean(batchWxMessageWrapperDto);
        return batchWxMessageWrapperDto;
    }


    private static  <T> void validatorBean(T t) {
        Set<ConstraintViolation<Object>> validateResult = validator.validate(t, Default.class);
        if (CollectionUtils.isNotEmpty(validateResult)){
            String message = validateResult.stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(";"));
            if (StringUtils.isBlank(message)){
                throw new MessageConfigErrorException("消息体的参数未按照具体要求填写！");
            }
            throw new MessageConfigErrorException(message);
        }
    }

}
