package cn.com.duiba.kjy.api.api.enums.push;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 业务推送类型
 * @author lizhi
 * @date 2021/12/24 5:49 下午
 */
@AllArgsConstructor
@Getter
public enum PushBizTypeEnum {
    DAILY(1L, "早报"),
    GRASS_CONTENT(2L, "种草素材"),
    HOT_CONTENT(3L, "热门文章"),
    EVENING(4L, "晚安心语"),
    ;

    /**
     * 业务类型值
     */
    private final Long type;

    /**
     * 业务类型描述
     */
    private final String desc;
}
