package cn.com.duiba.kjy.api.api.enums.push;


import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 销售员推送开关配置
 * @author lizhi
 * @date 2019/6/24 1:51 PM
 */
@Getter
@AllArgsConstructor
public enum SellerPushSwitchEnum {
    /**
     * 开启免打扰，一定要在PushLabelEnum.DISTURB标签下的第一个，前端对第一个做了特殊处理
     */
    NON_DISTURB(9, "开启免打扰", "开启后在设定时间内不会接收到消息推送"),
    //推送类型
    DAILY(1, "今日早报（06:30）", ""),
    MATERIAL(12, "种草素材（07:30）", ""),
    HOT_ARTICLE(4, "今日热文集锦（16:30）", ""),
    EVENING(3, "晚安心语（20:00）", ""),
    AFTERNOON(2, "午后话题更新", ""),
    VISIT(5, "意向客户来访", ""),
    DAILY_STATISTICS(6, "每日客户数据统计", ""),
    WEEKLY_STATISTICS(7, "运营周报（每周一10:00）", ""),
    DAILY_EARNINGS(8, "每日收益统计", ""),

    INTERACT_EXPIRE_REMIND(10, "推送授权失效提醒", ""),

    DAILY_SIGN(11, "日签海报更新", ""),

    ;


    /**
     * 推送类型
     */
    private final Integer pushType;

    /**
     * 推送名称
     */
    private final String pushName;

    /**
     * 说明
     */
    private final String explain;

    private static final Map<Integer, SellerPushSwitchEnum> ENUM_MAP = new HashMap<>();

    static{
        for(SellerPushSwitchEnum pushEnum : values()){
            ENUM_MAP.put(pushEnum.getPushType(), pushEnum);
        }
    }

    public static SellerPushSwitchEnum getByPushType(Integer pushType) {
        if (pushType == null) {
            return null;
        }
        return ENUM_MAP.get(pushType);
    }

    public Integer getLabel() {
        switch (this) {
            case DAILY:
            case MATERIAL:
            case HOT_ARTICLE:
            case EVENING:
                return SellerPushSwitchLabelEnum.MATERIAL.getLabel();
            case VISIT:
            case WEEKLY_STATISTICS:
                return SellerPushSwitchLabelEnum.VISIT_ME.getLabel();
            case NON_DISTURB:
                return SellerPushSwitchLabelEnum.DISTURB.getLabel();
            default:
                return null;
        }
    }
}
