package cn.com.duiba.kjy.api.api.remoteservice.wxwork.suite;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.wxwork.corpsuite.OtoH5UserInfoDTO;
import cn.com.duiba.kjy.api.api.dto.wxwork.corpsuite.OtoUserDetailInfoDTO;
import cn.com.duiba.kjy.api.api.dto.wxwork.corpsuite.SuiteH5UserInfoDetailDto;
import cn.com.duiba.kjy.api.api.dto.wxwork.corpsuite.SuiteH5UserInfoDto;

/**
 * @author liuyajun
 * @date 2022/03/24
 */
@AdvancedFeignClient
public interface RemoteCorpAgentH5LoginService {

    /**
     * 静默授权获取用户信息
     * @param agentid 企微自建应用唯一标识
     * @param code 授权码
     * @return 用户信息
     */
    OtoH5UserInfoDTO getUserInfoByCode(String agentid, String code);

    /**
     * 自建应用读取成员信息
     * @param agentid 企微自建应用唯一标识
     * @param userid
     * @return 用户信息
     */
    OtoUserDetailInfoDTO getUserInfoDetailByUserId(String agentid, String userid);
}
