package cn.com.duiba.kjy.api.api.dto.dingtalk;

import lombok.Data;
import org.apache.commons.lang3.tuple.Triple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-06-06 19:56
 */
@Data
public class DingTalkContent implements Serializable {

    private static final long serialVersionUID = 3978486440063102L;

    /**
     * 消息类型
     */
    private String msgtype;

    /**
     * 被@人的手机号。
     */
    private List<String> atMobiles;

    /**
     * 被@人的用户userid。
     */
    private List<String> atUserIds;

    /**
     * 是否@所有人。
     */
    private Boolean atAll;

    /**
     * 内容
     */
    private String content;

    /**
     * 文本
     */
    private String text;

    /**
     * 标题
     */
    private String title;

    /**
     * 图片url
     */
    private String picUrl;

    /**
     * 消息点击链接url
     */
    private String messageUrl;

    /**
     * 按钮排列方式 0：按钮竖直排列 1：按钮横向排列
     */
    private String btnOrientation;

    /**
     * 单个按钮标题
     */
    private String singleTitle;

    /**
     * 单个按钮链接
     */
    private String singleUrl;

    /**
     * 标题，点击链接
     */
    private LinkedHashMap<String, String> buttons = new LinkedHashMap<>();

    /**
     * 标题，点击链接，图片链接
     */
    private List<Triple<String, String, String>> links = new ArrayList<>();
}
