package cn.com.duiba.kjy.api.api.dto.mgm;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * mgm m2用户信息
 *
 * @author xuzhigang
 * @date 2023/3/2 09:38
 **/
@Data
public class MgmM2InfoDto implements Serializable {
    private static final long serialVersionUID = -918037768166864669L;

    /**
     * 被推荐人姓名(脱敏)
     * 例如：王**
     */
    private String custLocalName;

    /**
     * 被推荐人手机号(脱敏)
     * 例如：132****1234
     */
    private String custMobilePhone;

    /**
     * 申卡时间
     * 例如：yyyyMMdd
     */
    private Date createDate;

    /**
     * 初审日期
     * 例如：yyyyMMdd
     */
    private Date preAprvEndDt;

    /**
     * 激活日期
     * 例如：yyyyMMdd
     */
    private Date activationTime;

    /**
     * 首刷日期
     * 例如：yyyyMMdd
     */
    private Date cardFirstPurchaseDte;

    /**
     * 审批状态
     * {@link cn.com.duiba.kjy.api.api.enums.mgm.MgmM2StatusEnum}
     */
    private String cardStatusDesc;

    /**
     * 是否新户, 是/否
     */
    private String newCustFlag;

    /**
     * 申卡流水号
     */
    private String referenceNo;
}
