package cn.com.duiba.kjy.api.api.dto.openpl;

import cn.com.duiba.kjy.api.api.dto.WechatBaseResponseDto;
import lombok.Getter;
import lombok.Setter;

/**
 * Created by dugq on 2022/10/25.
 */
@Getter
@Setter
public class LastAuditStateDto extends WechatBaseResponseDto {
    private static final long serialVersionUID = 4497810333949041880L;

    /**
     * 最近审核版本
     */
    private String lastAuditVersion;

    /**
     * 最近审核状态
     */
    private Integer lastAuditState;

    /**
     * 最新的审核id
     */
    private Long auditId;

    /**
     * 当审核被拒绝时，返回的拒绝原因
     */
    private String reason;
    /**
     * 	当审核被拒绝时，会返回审核失败的小程序截图示例。用 竖线I 分隔的 media_id 的列表，可通过获取永久素材接口拉取截图内容
     */
    private String screenshot;
    /**
     * 版本描述
     */
    private String userDesc;

    /**
     * 时间戳，提交审核的时间
     */
    private Long submitAuditTime;
}
