package cn.com.duiba.kjy.api.api.dto.wxmessage.wxwork.messagepush.suitemessage;

import cn.com.duiba.kjy.api.api.dto.wxmessage.wxwork.messagepush.WxWorkBaseMessageDto;
import cn.com.duiba.kjy.api.api.enums.WxMessageTypeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;

/**
 * @author dugq
 * @date 2021/12/6 1:37 下午
 */
@Getter
@Setter
@ToString(callSuper = true)
public class TextMessageDto extends WxWorkBaseMessageDto {
    private static final long serialVersionUID = 4277467215304592505L;

    /**
     * 文字消息体。 最长不超过2048个字节
     *
     * 支持markDown语法
     *  # 标题      1～6级 #号和文字之间有空格
     *  **加粗**
     *  [这是一个链接](http://work.weixin.qq.com/api/doc)
     *  <font color="info">绿色</font>
     *  > 引用文字
     *
     * 自动替换占位符  {{sellerName}} {{uniqueMark}}
     * {@link cn.com.duiba.kjy.api.api.dto.wxmessage.wxwork.messagepush.wrap.SingleWxWorkMessageWrapperDto#setUser}中有填充userId和sellerId后，{{userId}}  {{sellerId}}也可自动填充
     * 其他需要替换的请在WxWorkMessageUserDto中的customMap中补充key-value
     */
    @NotBlank(message = "文字消息的内容不能为空")
    private String content;

    public TextMessageDto() {
        super(WxMessageTypeEnum.TEXT_CONTENT.getCode());
    }
}
