package cn.com.duiba.kjy.api.api.enums;

import cn.com.duiba.kjy.api.api.dto.wxmessage.wxwork.messagepush.WxWorkBaseMessageDto;

import java.util.Objects;

/**
 * 企微的消息类型
 * 每种类型有自己的param继承自{@link WxWorkBaseMessageDto}
 * 每种类型在wechat-service中有自己的参数转换器，继承自{@link cn.com.duiba.kjy.bo.wxwork.paramformat.ParamBeanConvertor}.
 */
public enum WxMessageTypeEnum {
    TEXT_CONTENT(1,"text","应用文字消息"),
    MINIPROGRAM_NOTICE(2,"miniprogram_notice","小程序通知"),
    TEMPLATE_MSG(3, "template_msg", "模板消息"),
    ;
    /**
     * 系统定义code
     */
    private final Integer code;
    /**
     * 对应微信消息的type
     */
    private final String wxType;
    /**
     * 描述
     */
    private final String desc;

    WxMessageTypeEnum(Integer code, String wxType, String desc) {
        this.code = code;
        this.wxType = wxType;
        this.desc = desc;
    }

    public String getWxType() {
        return wxType;
    }

    public final Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


    public static WxMessageTypeEnum getByCode(Integer code) {
        for (WxMessageTypeEnum e :values())
            if (Objects.equals(code, e.getCode())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的消息类型");
    }

}
