package cn.com.duiba.kjy.api.api.param.push;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 推送基础参数
 * @author lizhi
 * @date 2021/12/24 5:13 下午
 */
@Data
public class BasePushParam  implements Serializable {

    private static final long serialVersionUID = -3734240412300937856L;

    /**
     * 配置类型：1-业务推送，2-自定义推送
     * @see cn.com.duiba.kjy.api.api.enums.push.PushConfTypeEnum
     */
    @NotNull
    private Integer confType;

    /**
     * 业务推送时是业务枚举值，自定义推送时是自定义推送配置Id
     * @see cn.com.duiba.kjy.api.api.enums.push.PushBizTypeEnum
     */
    private Long pushBizId;

    /**
     * 是否需要过滤开启了免打扰的用户，true-过滤，false-不过滤
     */
    private boolean sellerPushSwitch;
}
