package cn.com.duiba.kjy.api.api.remoteservice.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.auth.OaUserInfoResultDto;

/**
 * @author xuzhigang
 * @date 2023/3/6 16:41
 **/
@AdvancedFeignClient
public interface RemoteCiticCreditApiService {
    /**
     * 获取中信信用卡小程序oaId
     * @return mpOaId
     */
    Long getMpOaId();

    /**
     * 获取公司id
     * @return 公司id
     */
    Long getCompanyId();

    /**
     * 根据code换取userInfo
     * @param code 加密code
     * @return userInfo
     */
    OaUserInfoResultDto getUserInfo(String code);

    /**
     * 是否是持卡人
     * @param openId 中信公众号openId
     * @return true-是持卡人 false-非持卡人
     */
    boolean isCardHolder(String openId);
}
