package cn.com.duiba.kjy.api.api.dto.auth;

import cn.com.duiba.kjy.api.api.dto.WechatBaseResponseDto;
import lombok.Data;

/**
 * @author dugq
 * @date 2020/11/20 9:44 上午
 */
@Data
public class AppUserTokenResultDto extends WechatBaseResponseDto {
    private static final long serialVersionUID = 7384643166888347647L;

    /**
     * 获取用户信息的凭证
     */
    private String userToken;

    /**
     * 用户凭证 {@link #userToken}的有效期
     * 一般为7200
     * 单位秒
     */
    private Long expires;

    /**
     * token失效时，可用refreshToken重新获取token
     * 有效期30天。固定
     */
    private String refreshToken;

    /**
     * 用户的openid
     */
    private String openId;

    /**
     * 用户授权的作用域，使用逗号（,）分隔
     */
    private String scope;

    /**
     * 当且仅当该移动应用已获得该用户的 userinfo 授权时，才会出现该字段
     */
    private String unionId;
}
