package cn.com.duiba.kjy.api.api.enums;


import cn.com.duiba.kjy.base.api.request.ErrorCodeInterface;

/**
 * Created by dugq on 2019-02-21.
 */
public enum ErrorCode implements ErrorCodeInterface {
    //通用
    DATE_ERROR("990001","数据错误"),
    SYSTEM("999999","系统错误"),

    //01 微信统一接口
    WECHAT_OA_TOKEN_ERROR("010001","token错误"),
    NOT_SUPPORT_MESSAGE("010002","不支持的消息"),
    REQUEST_FAIL("010003","请求失败"),

    //02 微信消息推送
    PARAM_ERROR("020001","参数错误"),
    FUNCTION_DOWN("020002","功能已下线"),

    //03 二维码绑定失败
    BIND_MP_QRCODE_ERROR("030001","绑定小程序二维码失败"),
    MP_QRCODE_CONFIG_ERROR("030002", "小程序码配置异常"),

    //04 oss
    OSS_UPLOAD_FAIL("040001", "上传oss失败"),

    //05企微
    PROVIDER_NOT_EXIST("050001","服务商不存在"),
    SUITE_NOT_EXIST("050002","应用不存在或者未启用"),
    SUITE_PRE_AUTH_CODE_ERROR("050003","生成预授权码失败"),
    SUIT_ACCESS_TOKEN_ERROR("050004","应用Token获取失败 "),
    THIRD_CORP_AUTH_ILLEGALITY("050005","第三方企微授权服务商应用非法"),
    THIRD_CORP_NOT_AUTH("050006","企业未授权"),
    CORP_NOT_EXIST("050007","企业不存在"),
    CORP_ACCESS_TOKEN_ERROR("050008","企业accessToken获取失败"),
    SUIT_MESSAGE_PUSH_TYPE_NOT_SUPPORT("050009","暂不支持的企微应用消息类型"),
    ;

    private final String shortCode;
    private final String desc;

    ErrorCode(String shortCode, String desc) {
        this.shortCode = shortCode;
        this.desc = desc;
    }

    public String getHost() {
        return "KW";//NOSONAR
    }

    public String getShortCode() {
        return shortCode;
    }

    public String getDesc() {
        return desc;
    }
}
