package cn.com.duiba.kjy.api.api.param;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/10/23 13:35
 */
@Data
public class WaterMakeParam implements Serializable {

    private static final long serialVersionUID = -2408383073089576938L;

    /**
     * 图片地址
     */
    @NotBlank
    private String imageUrl;

    /**
     * 是否处理成圆形图像
     */
    private boolean circle;

    /**
     * 圆形图像大小
     */
    private Integer circleSize;

    /**   以下是水印参数   **/

    /**
     * 缩放比例，不填默认不缩放，保持圆图大小
     */
    private Float scale;

    /**
     * 在背景图上的横坐标
     */
    private Integer width;

    /**
     * 在背景图上的纵坐标
     */
    private Integer height;
}
