package cn.com.duiba.kjy.api.api.param.menu;

import cn.com.duiba.kjy.api.api.param.WxBaseParam;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * 创建个性化菜单
 * @author lizhi
 * @date 2020/9/29 11:58 AM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class CreateConditionalMenuParam extends WxBaseParam {

    private static final long serialVersionUID = 1846949636452194243L;

    /**
     * 一级菜单数组，个数应为1~3个
     */
    @NotNull(message = "一级菜单列表不能为空")
    @Size(min = 1, max = 3, message = "一级菜单个数不能小于1个或超过3个")
    private List<ButtonParam> button;

    /**
     * 菜单匹配规则
     */
    @JSONField(name = "matchrule")
    @NotNull(message = "菜单匹配规则不能为空")
    private MatchRuleParam matchRule;

}
