package cn.com.duiba.kjy.api.api.param.menu;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 二级菜单
 * @author lizhi
 * @date 2020/10/9 10:00 AM
 */
@Data
public class SubButtonParam implements Serializable {

    private static final long serialVersionUID = 5253299139578660649L;

    /**
     * 菜单标题，不超过16个字节，子菜单不超过60个字节
     */
    @NotBlank(message = "菜单标题不能为空")
    @Length(max = 60, message = "菜单标题不能超过20个字符")
    private String name;

    /**
     * 菜单的响应动作类型，view表示网页类型，click表示点击类型，miniprogram表示小程序类型
     * @see cn.com.duiba.kjy.api.api.enums.WxMenuTypeEnum
     */
    @NotBlank(message = "类型不能为空")
    private String type;

    /**
     * 网页 链接，不超过1024字节, view、miniprogram类型必须
     */
    private String url;

    /**
     * 小程序的appid（仅认证公众号可配置），miniprogram类型必须
     */
    @JSONField(name = "appid")
    private String appId;

    /**
     * 小程序的页面路径，miniprogram类型必须
     */
    @JSONField(name = "pagepath")
    private String pagePath;

    /**
     * 菜单KEY值，用于消息接口推送，不超过128字节，click等点击类型必须
     */
    @Length(max = 128, message = "菜单标题不能超过128个字符")
    private String key;
}
