package cn.com.duiba.kjy.api.api.param.push;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;

/**
 * 销售推送参数
 * @author lizhi
 * @date 2021/12/24 4:41 下午
 */
@Data
public class SellerPushParam implements Serializable {

    private static final long serialVersionUID = 2105570980050415310L;

    /**
     * 销售ID
     */
    @NotNull
    private Long sellerId;

    /**
     * 销售维度的自定义参数，可为null。参数名重复时，优先级：个人自定义>批量自定义>系统自定义
     */
    private Map<String, Serializable> sellerCustomMap;

    /**
     * 销售维度自定义埋点参数，可为null。参数名重复时，优先级：个人自定义>批量自定义>系统自定义
     */
    private Map<String, Serializable> sellerEmbedMap;
}