package cn.com.duiba.kjy.api.api.remoteservice.auth;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.auth.AppUserInfoResultDto;
import cn.com.duiba.kjy.api.api.dto.auth.AppUserTokenResultDto;

/**
 * @author dugq
 * @date 2021/6/17 3:11 下午
 * 请注意，APP下的用户相关接口不需要APP级别的AccessToken作为接口调用凭证。这和公众号小程序是不同的。
 */
@AdvancedFeignClient
public interface RemoteAppAuthService {

    /**
     * 根据用户授权的code，获取AccessToken,和openId等信息
     * @param oaId 公众号ID
     * @param code 静默授权code
     */
    AppUserTokenResultDto getUserTokenByCode(Long oaId , String code);

    /**
     * 根据accessToken获取用户token和openId
     * 此接口获取不到unionId。一般场景下unionId可通过客户端微信接口直接获取到。如果确实需要可通过accessToken再次调用{@link #getUserTokenByCode}
     * @param userRefreshToken 客户端授权返回的refreshToken
     * @param appId 微信app对象的appID
     * @return accessToken和openID
     */
    AppUserTokenResultDto refreshToken(String userRefreshToken,String appId);
    /**
     * 根据access_token获取用户基本信息。<br/>
     * <span color="red">注意：第三方开放平台下的公众号获取用户信息，也使用这个接口。</span>
     * @param accessToken {#getUserTokenByCode}返回的accessToken
     * @param openId {#getUserTokenByCode}返回的openId
     * @return 用户基本信息
     */
    AppUserInfoResultDto getUserInfoByAccessToken(String accessToken, String openId);

}
