package cn.com.duiba.kjy.api.api.remoteservice.citic.credit.mgm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.mgm.MgmM2InfoDto;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2023/3/31 10:36
 **/
@AdvancedFeignClient
public interface RemoteMgmApiService {
    /**
     * 查询M1邀请进度
     *
     * @param promotionCode 推荐码
     * @return 邀请进度
     */
    List<MgmM2InfoDto> listM2Info(String promotionCode);

    /**
     * 获取申卡链接分享时间
     *
     * @return 分享时间
     */
    String getApplyLinkShareTime();

    /**
     * 发送档位变更短信
     *
     * @param promotionCode 推荐码
     * @param level         档位
     * @return 发送结果
     */
    boolean sendLevelChangeMsg(String promotionCode, Integer level);

    /**
     * 发送面签短信
     *
     * @param referenceNo 卡超市流水号
     * @param recommendNo 推荐码
     * @return 请求相应码
     */
    String sendFaceSigningMsg(String referenceNo, String recommendNo);

    /**
     * 获取推荐号
     *
     * @param phone 手机号
     * @return 推荐号
     */
    String liveCondition(String phone);
}
