package cn.com.duiba.kjy.api.api.remoteservice.image;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.param.CreatePosterParam;
import cn.com.duiba.kjy.api.api.param.PosterParam;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/10/23 13:47
 */
@AdvancedFeignClient
public interface RemoteImageService {

    /**
     * 构建海报并获取微信素材id
     * 请直接使用{@link RemoteImageService#buildPosterAndPushToUser(PosterParam)}
     * @param posterParam 海报参数
     * @return 微信素材id
     */
    @Deprecated
    String buildPosterAndGetMediaId(PosterParam posterParam);

    /**
     * 构建海报并推送给用户
     * @param posterParam 海报参数
     */
    void buildPosterAndPushToUser(PosterParam posterParam);

    /**
     * 创建海报
     * 根据海报和水印画海报 上传至oss 结果缓存至redis
     *
     * @param createPosterParam 创建海报参数
     */
    void createPoster(CreatePosterParam createPosterParam);
}
