package cn.com.duiba.kjy.api.api.remoteservice.openpl;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.WechatBaseResponseDto;
import cn.com.duiba.kjy.api.api.dto.openpl.*;

import java.util.List;

/**
 *  <h1>代码操作步骤</h1>
 * <li>1、兑吧发布平台或者开发者本地打包模版小程序。前端打包脚本调用{@link #buildAndAdd2Template}将代码提交到模版库，并返回模版ID</li>
 * 2、通过{@link #commitCode}将代码提交到体验版本.模版ID通过{@link #getTemplateList}获取模版列表<br/>
 * 3、通过{@link #getTrialQRCode}获取指定小程序的体验码<br/>
 * 6、通过{@link #submitAudit}将指定小程序的体验版本代码提交审核<br/>
 * 7、通过{@link #getAuditStatus}查询指定小程序的审核状态<br/>
 * 8、期间可撤回{@link #undoAudit}小程序的审核<br/>
 * 9、审核通过后可通过{@link #release}发布指定小程序版本<br/>
 * 10、发布过后有问题可通过{@link #revertCodeRelease}回滚版本。如果需要回滚到指定版本，可通过{@link #getLastReleaseVersionList}获取版本号
 *
 * <h1>小程序当前状态查询</h1>
 * <li>查询小程序版本信息{@link #getMpVersionInfo}</li>
 * <li>查询最近一次审核信息{@link #getLastAuditInfo(Long)}</li>
 *
 * Created by dugq on 2022/10/20.
 */
@AdvancedFeignClient
public interface RemoteComponentCodeMngService {

    SubmitCodeTemplateDto buildAndAdd2Template(Long openPlOaId, String version);

    List<SubmitCodeTemplateDto> getTemplateList(Long openPlOaId);

    WechatBaseResponseDto commitCode(Long oaId, Long templateId);

    String getTrialQRCode(Long oaId, String path);

    AuditResultDto submitAudit(Long oaId, String feedback);

    AuditStateResultDto getAuditStatus(Long oaId, String auditId);

    WechatBaseResponseDto undoAudit(Long oaId);

    WechatBaseResponseDto release(Long oaId);

    MpVersionDto getMpVersionInfo(Long oaId);

    LastAuditStateDto getLastAuditInfo(Long oaId);


    /**
     * 在微信回调更新审核状态时，刷新最近一次审核状态缓存
     */
    void clearLastAuditInfoCache(Long oaId);

    List<LastReleaseVersionDto>  getLastReleaseVersionList(Long oaId);

    /**
     * @param appVersion null 默认回滚到上一个版本
     */
    WechatBaseResponseDto revertCodeRelease(Long oaId, Long appVersion);
}
