package cn.com.duiba.kjy.api.api.remoteservice.openpl;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author dugq
 * @date 2020/11/24 11:50 下午
 */
@AdvancedFeignClient
public interface RemoteComponentOaInfoService {
    /**
     * 1、在授权成功后，根据authCode获取授权公众号的AuthInfo
     * 2、根据authInfo的appId获取oa accountInfo
     * 3、保存授权公众号到数据库
     * @param authCode 授权码
     * @return 0：失败 1：成功
     * @deprecated {@link #saveOpenPlAuthedOaInfo} 必须指定开发平台
     */
    @Deprecated
    int saveAuthedOaInfo(String authCode);

    /**
     * 第三方服务平台测试用例
     * 微信要求必须有。
     * @deprecated {@link #openPlTest} 必须指定开发平台
     */
    @Deprecated
    void openPlTestCase(String authCode,String openId);


    /**
     * 1、在授权成功后，根据authCode获取授权公众号的AuthInfo
     * 2、根据authInfo的appId获取oa accountInfo
     * 3、保存授权公众号到数据库
     * @param authCode 授权码
     * @return 0：失败 1：成功
     */
    long saveOpenPlAuthedOaInfo(String authCode,Long openPlId);

    /**
     * 第三方服务平台测试用例
     * 微信要求必须有。
     */
    void openPlTest(String authCode,String openId,Long openPlId);
}
