package cn.com.duiba.kvtable.service.api.remoteservice.hbase;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 适用于最后一位数字或者字母不唯一的情况,适用方可以适当调整rowkey的拼接达到使用的要求
 *
 * 该hbase接口用于解决hbase热点问题,从新设计的新接口
 * 原来的hbase rowkey存在一定热点问题
 *
 * 传入的rowkey底层反转rowkey来解决热点分布不均的问题,所以建议最后一段是用户id或者是商品id这样类似的唯一标识
 *
 * Created by sunchangji on 2018/8/30.
 */
@AdvancedFeignClient
public interface RemoteHbApiKvNoHotspotService {

    /**
     * 根据rowkey获取value是string类型的值
     *
     * @param rowkey
     * @return null表示不存在或该存储的值不是String类型
     */
    String getStringByKey(String rowkey);

    /**
     * 增加或更新字符串的value
     *
     * @param rowkey
     * @param value
     * @return
     */
    boolean upsertKStrV(String rowkey, String value);

    /**
     * 根据key获取value是long型的值,如果不是long的值会返回null
     *
     * @param rowkey
     * @return nnull表示不存在或该存储的值不是Long型
     */
    Long getLongByKey(String rowkey);

    /**
     * 增加或更新long类型的value
     *
     * @param rowkey
     * @param value
     * @return
     */
    boolean upsertKLongV(String rowkey, long value);

    /**
     * 对key的long value做increase操作,不存在会新增一条记录
     *
     * @param rowkey
     * @param incrNum
     * @return 返回increase后的值
     */
    Long increaseByKey(String rowkey, long incrNum);

    /**
     * 根据key删除
     * @param rowkey
     */
    void deleteByKey(String rowkey);

}
