package cn.com.duiba.kvtable.service.api.enums;

/**
 * @author: LuHui
 * @date: 2023/10/16 14:06
 * @description:
 */
public enum TradeWebHBaseKeyEnum {

    K001("商品已兑数量"),
    ;

    private String desc;

    TradeWebHBaseKeyEnum(String desc){
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * trade web:trade-access-web HBase key space
     */
    private static final String SPACE = "TAWH";

    private static final String SEPARATOR = "_";

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString()+"_";
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg : args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }
}
