package cn.com.duiba.kvtable.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kvtable.service.api.dto.KVDto;
import cn.com.duiba.kvtable.service.api.enums.KVSpaceEnum;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author liugq
 * @date created in 2018/4/14
 * @description:
 */
@AdvancedFeignClient
public interface RemoteKvTableService {

    /**
     * 按照vspace,key进行查询
     *
     * @param space
     * @param consumerId
     * @param key
     * @return
     */
    KVDto get(KVSpaceEnum space, Long consumerId, String key) throws BizException;

    /**
     * 按照vspace批量查询
     *
     * @param space
     * @param consumerId
     * @return
     */
    List<KVDto> mulGetByKeys(KVSpaceEnum space, Long consumerId, Set<String> keys) throws BizException;

    /**
     * 按照vspace,key进行查询
     *
     * @param space
     * @param consumerId
     * @return
     */
    List<KVDto> mulGetBySpace(KVSpaceEnum space, Long consumerId) throws BizException;

    /**
     * 单条数据插入
     *
     * @param dto
     * @return
     */
    Boolean insert(KVDto dto, Long consumerId);

    /**
     * 批量插入
     *
     * @param dtos
     * @param consumerId
     * @return
     */
    Boolean mulInsert(List<KVDto> dtos, Long consumerId);

    /**
     * 单条数据修改
     *
     * @param dto
     * @return
     */
    Boolean update(KVDto dto, Long consumerId);

    /**
     * @param space
     * @param key
     * @param count
     * @return
     */
    Boolean increase(KVSpaceEnum space, String key, Long consumerId, int count);

    /**
     * @param space
     * @param key
     * @param count
     * @return
     */
    Boolean insertOrIncrease(KVSpaceEnum space, String key, Long consumerId, int count);

    /**
     * 单条数据插入或者更新
     *
     * @param dto
     * @return
     */
    Boolean insertOrUpdate(KVDto dto, Long consumerId);

    /**
     * 批量添加/插入数据数据
     * 该方法抽取背景为，在intersection-service下线后原业务方调用方法：{@link RemoteKVService#sets}的替代方法
     * 注：此处的update实现为{@link RemoteKvTableService#increase}
     *
     * @param space      使用KVSpaceEnum定义的常量{@link KVSpaceEnum}，未定义的space会抛出异常
     * @param consumerId 用户ID
     * @param keys       查询的key集合
     * @return true 成功，false 失败
     * @throws IllegalArgumentException
     */
    Boolean mulInsertOrUpdate(KVSpaceEnum space, Long consumerId, Map<String, Long> keys);
}