package cn.com.duiba.live.clue.center.api.dto.ws;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2020/3/24 7:05 PM
 * 推送 标准 dto。分为【消息指令标记】 和 【消息体】
 *
 * 在【通用队列】使用时，返回值 T 固定为 jsonObject 。因为redis 反序列化的问题。
 * 通用队列】在redis中维护一个队列，定时【每秒】遍历队列给所有用户进行推送
 */
@Data
public class WsResultDto<T extends Serializable> implements Serializable {

    private static final long serialVersionUID = -1805468380865599407L;
    /**
     * 推送的消息类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.WsMsgTypeEnum
     */
    @JSONField(name = "t")
    private int msgType;

    /**
     * 响应数据
     */
    @JSONField(name = "d")
    private T data;
}
