package cn.com.duiba.live.clue.center.api.enums.red;

/**
 * 直播领红包状态
 * @author lizhi
 * @date 2020/6/22 5:44 PM
 */
public enum LiveRedPacketReceiveStateEnum {

    //              参与
    //             /   \
    //        1(有凭证) 3(无凭证)
    //        /      \
    //  2(微信成功)  4(微信失败)
    INIT(0,"初始状态,表示已参与"),
    RECEIVING(1, "领取中"),
    RECEIVE_SUCCESS(2, "领取成功"),
    RECEIVE_FAIL(3, "领取失败"),
    WX_RECEIVE_FAIL(4, "微信领取失败"),
    ;

    private Integer code;
    private String desc;

    LiveRedPacketReceiveStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
