package cn.com.duiba.live.clue.center.api.remoteservice.lottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.center.api.dto.lottery.LiveLotteryCollectDto;

import java.util.List;

/**
 * 直播抽奖
 * @author dugq
 * @date 2020-07-06
 */
@AdvancedFeignClient
public interface RemoteLiveRewardLotteryService {

    /**
     * 收集在线用户
     * @param list 用户信息
     */
    void collect(List<LiveLotteryCollectDto> list);

    /**
     * 预热抽奖，将用户添加到抽奖池中
     * @param list 用户信息
     */
    void preCollect(List<LiveLotteryCollectDto> list);

    /**
     * 异步执行抽奖任务
     * @param liveId 直播ID
     * @param confId 福利配置ID
     * @param topic 回调的mq的topic
     * @param tag 回调的mq的tag
     *            回调内容结构 {"liveId":1,"confId":2}
     */
    void asyncDrawAndSendMq(Long liveId, Long confId, String topic, String tag);

}
