package cn.com.duiba.live.clue.center.api.dto.activity.time.red;

import cn.com.duiba.live.clue.center.api.constant.TimeRedUserRecordHashKeyConstant;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * 时长红包-用户记录
 * @author lizhi
 * @date 2021/6/9 2:45 下午
 */
@Data
public class TimeRedUserRecordDto implements Serializable {

    private static final long serialVersionUID = -1422164131740238816L;

    /**
     * 最后一次领取时间戳
     */
    @JSONField(name = TimeRedUserRecordHashKeyConstant.LAST_TIME)
    private Long lastTime;

    /**
     * 已领取总金额
     */
    @JSONField(name = TimeRedUserRecordHashKeyConstant.TOTAL_AMOUNT)
    private Integer totalAmount;

    /**
     * 是否已结束
     * @see cn.com.duiba.kjy.base.api.enums.BooleanEnum
     */
    @JSONField(name = TimeRedUserRecordHashKeyConstant.HAS_END)
    private Integer hasEnd;

    /**
     * 已领取轮次ID集合
     */
    @JSONField(name = TimeRedUserRecordHashKeyConstant.RECEIVE_IDS)
    private String receiveIds;

    /**
     * 提现状态，0-未提现，1-提现中，2-提现成功，3-提现失败，4-提现成功，发钱失败
     * @see cn.com.duiba.live.clue.center.api.enums.red.LiveRedPacketReceiveStateEnum
     */
    @JSONField(name = TimeRedUserRecordHashKeyConstant.WITHDRAW_STATUS)
    private Integer withdrawStatus;

    /**
     * 提现失败错误码
     * @see cn.com.duiba.live.clue.center.api.enums.avtivity.time.red.TimeRedFailCodeEnum
     */
    @JSONField(name = TimeRedUserRecordHashKeyConstant.WITH_FAIL_CODE)
    private Integer withFailCode;

    /**
     * 领取抽奖码状态，0-未领取，1-领取成功，2-领取失败
     * @see cn.com.duiba.live.clue.center.api.enums.avtivity.time.red.TimeRedCodeStatusEnum
     */
    @JSONField(name = TimeRedUserRecordHashKeyConstant.CODE_STATUS)
    private Integer codeStatus;

    /**
     * 领取抽奖码失败原因
     * @see cn.com.duiba.live.clue.center.api.enums.avtivity.time.red.TimeRedFailCodeEnum
     */
    @JSONField(name = TimeRedUserRecordHashKeyConstant.FAIL_CODE)
    private Integer failCode;
}
