package cn.com.duiba.live.clue.center.api.dto.flip.word;

import cn.com.duiba.live.clue.center.api.enums.flip.word.FlipWordReceiveStateEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhuenhui
 * @date 2021/06/28 5:13 下午
 * @description 翻牌集字 - 用户单次翻牌结果
 */
@Data
public class FlipWordUserFlipResDto implements Serializable {

    private static final long serialVersionUID = 1393127360309439557L;

    /**
     * 翻牌位置
     */
    private Integer pos;

    /**
     * 翻牌渠道
     *
     * @see cn.com.duiba.live.clue.center.api.enums.flip.word.FlipWordHelpStatusEnum
     */
    private Integer helpState;

    /**
     * 翻牌结果类型
     *
     * @see cn.com.duiba.live.clue.center.api.enums.flip.word.FlipWordResultTypeEnum
     */
    private Integer resultType;

    /**
     * 翻牌状态
     *
     * @see FlipWordReceiveStateEnum
     */
    private Integer receiveState;

    /**
     * 翻牌时间
     */
    private Date turnTime;

    /**
     * 失败原因
     */
    private Integer failCode;

}
