package cn.com.duiba.live.clue.center.api.enums.flip.word;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author zhuenhui
 * @date 2021/06/29 9:30 下午
 * @description 翻牌集字 - 翻牌结果类型
 */
@Getter
@AllArgsConstructor
public enum FlipWordResultTypeEnum {
    CARD_FU(1, "福"),
    CARD_LU(2, "禄"),
    CARD_SHOU(3, "寿"),
    CARD_XI(4, "禧"),
    CARD_CAI(5, "财"),
    LOTTERY_CODE(6, "抽奖码"),
    THANKS(7, "谢谢参与");

    private final Integer code;
    private final String desc;

    public static boolean isWord(Integer code) {
        if (code == null) {
            return false;
        }
        return !LOTTERY_CODE.getCode().equals(code)  && !THANKS.getCode().equals(code);
    }
}