package cn.com.duiba.live.clue.center.api.enums.treasure;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 直播前宝箱领取状态
 * @author wuwenzhe
 */
@AllArgsConstructor
@Getter
public enum LiveTreasureReceiveStateEnum {

    //             参与
    //              |
    //           1(领取中)
    //        /      \        \
    //  2(领取成功)  3(领取失败) 4(微信领取失败)
    INIT(0,"初始状态,表示已参与"),
    RECEIVING(1, "领取中"),
    RECEIVE_SUCCESS(2, "领取成功"),
    RECEIVE_FAIL(3, "领取失败"),
    WX_RECEIVE_FAIL(4, "红包-微信领取失败"),
    ;

    private final Integer code;
    private final String desc;

}
