package cn.com.duiba.live.clue.center.api.param.invitation;

import lombok.Data;

import java.io.Serializable;

/**
 * 批量绑定关系
 * @author dugq
 * @date 2020-04-01
 */
@Data
public class BindingInvitationParam implements Serializable {

    private static final long serialVersionUID = -4505572425541687634L;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 邀请人id
     */
    private Long inviterId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 渠道（推广小程序码的渠道埋点）
     */
    private String channelId;

    /**
     * 邀请来源
     * @see cn.com.duiba.live.clue.service.api.enums.invitation.InviteSourceEnum
     */
    private Integer inviteSource;

    /**
     * 分享类型
     * @see cn.com.duiba.live.normal.service.api.enums.help.LiveHelpShareTypeEnum
     */
    private Integer shareType;
}
