package cn.com.duiba.live.clue.center.api.dto.activity.time.red;

import cn.com.duiba.kjy.base.api.enums.BooleanEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * 时长红包-用户开红包结果
 * @author lizhi
 * @date 2021/6/10 10:37 上午
 */
@Data
public class TimeRedUserOpenResultDto implements Serializable {

    private static final long serialVersionUID = -2322943554175524841L;

    /**
     * 轮次ID
     */
    private Long id;

    /**
     * 状态：1-领取中，2-领取成功，3-领取失败
     * @see cn.com.duiba.live.clue.center.api.enums.avtivity.time.red.TimeRedOpenStateEnum
     */
    private Integer state;

    /**
     * 错误码
     * @see cn.com.duiba.live.clue.center.api.enums.avtivity.time.red.TimeRedFailCodeEnum
     */
    private Integer failCode;

    /**
     * 是否已结束
     * @see cn.com.duiba.kjy.base.api.enums.BooleanEnum
     */
    private Integer hasEnd = BooleanEnum.FALSE.getCode();

    /**
     * 领取金额
     */
    private Integer amount;
}
