package cn.com.duiba.live.clue.center.api.dto.red;

import lombok.Data;

import java.io.Serializable;

/**
 * 直播间开启红包Dto
 *
 * @author 吴文哲
 * @date 2021/9/3 3:09 下午
 **/
@Data
public class AbstractLiveOpenRedPackDto implements Serializable {
    private static final long serialVersionUID = 2297473134008984794L;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 业务配置id 一些既有红包 又有奖品的业务会有值
     * 例如: 有奖答题
     */
    private Long bizConfId;

    /**
     * 红包配置id
     */
    private Long confId;

    /**
     * 直播访客id
     */
    private Long liveVisitorId;

    /**
     * 业务方id
     */
    private String bizUserId;

    /**
     * 访客当前ip
     */
    private String ip;
}
