package cn.com.duiba.live.clue.center.api.enums.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 直播订单处理枚举
 *
 * @author 吴文哲
 * @date 2021/8/20 5:41 下午
 **/
@AllArgsConstructor
@Getter
public enum LiveOrderHandlerEnum {

    SEC_KILL(1, "直播间秒杀");

    /**
     * 类型
     */
    private final int type;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, LiveOrderHandlerEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(
                    LiveOrderHandlerEnum::getType, Function.identity()
            )));


    public static LiveOrderHandlerEnum getByType(Integer type) {
        if(Objects.isNull(type)){
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
