package cn.com.duiba.live.clue.center.api.dto.quesreward;

import lombok.Data;

import java.io.Serializable;

/**
 * 直播答题领奖用户参与结果查询
 * @author 吴文哲
 * @date 2021/3/22 5:03 下午
 **/
@Data
public class LiveQuesRewardUserParticipateDto implements Serializable {
    private static final long serialVersionUID = 1306753874278580298L;


    /**
     * 当前答题结果
     * true:答对了
     * false:答错了
     */
    private boolean result;

    /**
     * 答题次数
     */
    private long count;

    /**
     * 奖品类型 1:答题送红包 2:答题送奖品 3:答题送抽奖券
     */
    private Integer quesType;

    /**-----------红包相关-----------**/
    /**
     * 答题红包金额
     *
     */
    private Integer amount;

    /**
     * 红包领取状态
     */
    private Integer redReStatus;

    /**-----------奖品相关------------**/
    /**
     * 奖品领取状态
     */
    private Integer welfareStatus;

    /**
     * 奖品名称
     */
    private String rewardName;

    /**
     * 奖品图片
     */
    private String rewardImg;

    /**
     * 用户提交的获奖姓名
     */
    private String winnerName;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * true-商城版
     */
    private boolean goodsVersion;

    /**
     * spuId
     */
    private Long saleGoodsId;

    /**
     * 发货方式
     * {@link cn.com.duiba.live.conf.service.api.enums.mall.salegoods.DeliveryWayTypeEnum}
     */
    private Integer deliveryWay;

    /**-----------抽奖券相关------------**/
    /**
     * 抽奖券领取状态
     */
    private Integer lotteryStatus;

}
