package cn.com.duiba.live.clue.center.api.enums.mall.order;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Map;

/**
 * @author xuzhigang
 * @date 2022/8/11 4:39 下午
 **/
@Getter
@AllArgsConstructor
public enum MallOrderFailEnum {

    UNKNOWN(0, "未知错误"),
    PARAM_ERROR(1,"参数错误"),
    GOODS_NOT_FOUND(2, "商品已下架"),
    USER_ADDRESS_NOT_FOUND(3, "收货地址不存在"),
    USER_ADDRESS_LIMIT(4, "发货地址限制"),
    FREQUENTLY_ORDER(5, "下单频繁"),
    USER_INFO_NOT_FOUND(6, "用户信息异常"),
    BLACKLIST(7, "黑名单用户"),
    BUY_NUM_LIMIT(8, "购买数量超过限制"),
    STOCK_NOT_ENOUGH(9, "库存不足"),
    USER_OA_INFO_ERROR(10, "用户信息异常"),
    UNKNOWN_EXCEPTION(11, "未知异常"),
    BANK_ACTIVITY_IS_INVALID(12, "办卡活动无效"),
    BANK_ACTIVITY_NOT_APPLY_CARD(13, "未在办卡活动中完成进件"),
    BANK_ACTIVITY_BUY_NUM_LIMIT(14, "您下单的办卡福利商品已达上限，不要贪心哦~"),
    LIVE_ACTIVITY_ORDER_NOT_FOUND(15, "直播活动定单不存在"),
    USER_HOLD_CARD_LIMIT(16, "用户持卡状态与商品规定的限购类型不一致"),
    GOODS_SKU_NOT_ENABLE(17, "商品规格已下架，请重试"),
    COUPON_ERROR(18, "优惠券不可用"),
    COUPON_DISABLE(19, "优惠券已失效"),
    ORDER_PRICE_UPDATE(20, "订单价格更新"),
    COUPON_UNUSEFUL(21, "商品不支持的优惠券"),
    GOODS_PURCHASE_LIMIT(22, "特殊商品购买限制"),
    /**
     * 拼团相关
     */
    GROUP_IS_END(23, "拼团已结束"),
    GROUP_NUM_FULL(24, "拼团人数已满"),
    GROUP_LIMIT_ONCE(25, "拼团只能参与一次"),
    GROUP_CONF_ERROR(26, "拼团配置异常"),
    GROUP_RECORD_NOT_FOUND(27, "拼团记录不存在"),
    GROUP_HAS_JOIND(28, "已参与过拼团")
    ;

    private final Integer code;

    private final String msg;


    private static Map<Integer, MallOrderFailEnum> map = new HashMap<>();

    static {
        for (MallOrderFailEnum value : values()) {
            map.put(value.getCode(), value);
        }
    }

    public static String getMsgByCode(Integer code) {
        return getByCode(code).getMsg();
    }

    @NotNull
    public static MallOrderFailEnum getByCode(Integer code) {
        return map.getOrDefault(code, UNKNOWN);
    }
}
