package cn.com.duiba.live.clue.center.api.dto.mall.coupon;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.ToString;

import java.io.Serializable;

@Getter
@EqualsAndHashCode
@ToString
public class MallCouponGrantDto implements Serializable {
    private static final long serialVersionUID = -8220092915666328078L;

    private final Long liveUserId;

    private final Long mallCouponId;

    /**
     * 发放类型：1-手动领取 2-自动发放
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.coupon.MallUserCouponReceiveTypeEum}
     */
    private final Integer receiveType;

    public MallCouponGrantDto(Long liveUserId, Long mallCouponId, Integer receiveType) {
        this.liveUserId = liveUserId;
        this.mallCouponId = mallCouponId;
        this.receiveType = receiveType;
    }
}
