package cn.com.duiba.live.clue.center.api.dto.mall.group;

import cn.com.duiba.live.conf.service.api.dto.mall.salegoods.MallSaleSpuExtDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.apache.commons.collections.MapUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author xuzhigang
 * @date 2023/5/10 18:20
 **/
@Data
public class GroupRecordRedisDto implements Serializable {
    private static final long serialVersionUID = 1380678559587798373L;

    public static final String REMAINING_NUM = "1";

    public static final String EXPIRE_TIME = "2";

    public static final String GROUP_STATUS = "3";

    public static final String MEMBERS = "4";

    public static final String GOODS_INFO = "5";

    public static final String GROUP_CONF = "6";

    /**
     * 剩余拼团人数
     */
    @JSONField(name = REMAINING_NUM)
    private int remainingNum;

    /**
     * 拼团剩余时间 时间戳/ms
     */
    @JSONField(name = EXPIRE_TIME)
    private long expireTime;

    /**
     * 拼团状态
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.group.GroupStatusEnum}
     */
    @JSONField(name = GROUP_STATUS)
    private Integer groupStatus;

    /**
     * 拼团成员 用户id逗号拼接
     */
    @JSONField(name = MEMBERS)
    private List<GroupMember> members;

    /**
     * 拼团商品信息
     */
    @JSONField(name = GOODS_INFO)
    private GoodsInfo goodsInfo;

    /**
     * 拼团信息
     */
    @JSONField(name = GROUP_CONF)
    private MallSaleSpuExtDto.GroupConfDto groupConf;

    @Data
    public static class GoodsInfo implements Serializable {
        private static final long serialVersionUID = -933432435992289734L;

        /**
         * 商品id
         */
        private Long spuId;
    }

    @Data
    public static class GroupMember {
        /**
         * 直播用户id
         */
        private Long liveUserId;

        /**
         * 订单id
         */
        private Long orderId;

        /**
         * 拼团状态
         */
        private Integer joinGroupStatus;
    }

    public static GroupRecordRedisDto parseRedisHashVal(Map<Object, Object> redisHashVal) {
        if (MapUtils.isEmpty(redisHashVal)) {
            return null;
        }
        GroupRecordRedisDto dto = new GroupRecordRedisDto();
        dto.setRemainingNum(Integer.parseInt(redisHashVal.get(REMAINING_NUM).toString()));
        dto.setExpireTime(Long.parseLong(redisHashVal.get(EXPIRE_TIME).toString()));
        dto.setGroupStatus(Integer.parseInt(redisHashVal.get(GROUP_STATUS).toString()));
        dto.setMembers(JSON.parseArray(String.valueOf(redisHashVal.get(MEMBERS)), GroupMember.class));
        dto.setGoodsInfo(JSON.parseObject(String.valueOf(redisHashVal.get(GOODS_INFO)), GoodsInfo.class));
        dto.setGroupConf(JSON.parseObject(String.valueOf(redisHashVal.get(GROUP_CONF)), MallSaleSpuExtDto.GroupConfDto.class));
        return dto;
    }

}
