package cn.com.duiba.live.clue.center.api.remoteservice.mall.refund;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhuenhui
 * @date 2022/08/16 19:56
 * @description 商城 - 订单退款 RPC
 */
@AdvancedFeignClient
public interface RemoteMallRefundService {

    /**
     * 发起退款
     *
     * @param orderId      订单Id
     * @param refundReason 退款原因
     * @param refundAmount 退款金额
     * @return 处理结果
     */
    boolean refund(Long orderId, String refundReason, Integer refundAmount);

}