/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.clue.center.api.utils.mall;

import cn.com.duiba.kjy.base.api.utils.SnowflakeUtils;
import java.util.Calendar;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MallOrderNoUtil {
    private static final Logger log = LoggerFactory.getLogger(MallOrderNoUtil.class);

    public static String getOrderNo() {
        return MallOrderNoUtil.getTradeNo(OrderNoTypeEnum.ORDER.getType());
    }

    public static String getAfterSaleOrderNo() {
        return MallOrderNoUtil.getTradeNo(OrderNoTypeEnum.AFTER_ORDER.getType());
    }

    public static String getRefundNo() {
        return MallOrderNoUtil.getTradeNo(OrderNoTypeEnum.REFUND.getType());
    }

    private static String getTradeNo(String type) {
        return DateFormatUtils.format((Calendar)Calendar.getInstance(), (String)"MMdd") + type + SnowflakeUtils.genId();
    }

    public static void main(String[] args) {
        System.out.println(MallOrderNoUtil.getOrderNo());
    }

    private static enum OrderNoTypeEnum {
        ORDER("01", "\u8ba2\u5355"),
        AFTER_ORDER("02", "\u552e\u540e\u5355"),
        REFUND("03", "\u9000\u6b3e\u5355");

        private final String type;
        private final String desc;

        public String getType() {
            return this.type;
        }

        public String getDesc() {
            return this.desc;
        }

        private OrderNoTypeEnum(String type, String desc) {
            this.type = type;
            this.desc = desc;
        }
    }
}

