package cn.com.duiba.live.clue.service.api.remoteservice.flipcard;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.flipcard.LiveFlipLuckyRecordDto;

import java.util.List;

/**
 * 翻牌集字-天降幸运活动
 *
 * @author ZhangJun
 * @date 2021/10/8 11:49 上午
 */
@AdvancedFeignClient
public interface RemoteLiveFlipLuckyRecordService {

    /**
     * 批量保存更新天降幸运活动记录
     *
     * @param dtos 需要保存的记录
     * @return 成功数量
     */
    int batchSaveOrUpdate(List<LiveFlipLuckyRecordDto> dtos);

    /**
     * 批量修改幸运活动的状态
     *
     * @param ids         需要修改状态的主键id集合
     * @param luckyStatus 需要设置的活动状态
     * @return 执行结果
     */
    int batchUpdateStatus(List<Long> ids, Integer luckyStatus);

}
