package cn.com.duiba.live.clue.service.api.enums.mall.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 商城订单状态枚举
 *
 * @author xuzhigang
 * @date 2022/8/9 10:35 上午
 **/
@Getter
@AllArgsConstructor
public enum MallOrderStatusEnum {

    INIT(1, "订单初始化"),

    ORDER_FAIL(2, "下单失败"),

    WAIT_PAY(3, "待支付"),

    CANCEL_PAY(4, "取消支付"),

    TIME_OUT_CANCEL_PAY(5, "超时取消支付"),

    PAY_FAIL(6, "支付失败"),

    DELIVERY_WAIT_AUDIT(7, "发货待审核"),

    DELIVERY_AUDIT_FAIL(8, "发货审核失败"),

    WAIT_DELIVERY(9, "待发货"),

    WAIT_RECEIPT(10, "待收货"),

    CONFIRM_RECEIPT(11, "确认收货");

    private final Integer code;

    private final String desc;
}
