package cn.com.duiba.live.clue.service.api.remoteservice.mall.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.mall.order.MallOrderDto;

import java.util.Date;

/**
 * 商城-订单相关
 *
 * @author xuzhigang
 * @date 2022/8/10 11:42 上午
 **/
@AdvancedFeignClient
public interface RemoteMallOrderService {
    /**
     * 根据id查询
     * @param id 主键id
     * @return 订单信息
     */
    MallOrderDto selectById(Long id);

    /**
     * 更新
     *
     * @param entity 订单数据
     * @return 执行结果
     */
    int update(MallOrderDto entity);

    /**
     * 新增
     * @param en 订单数据
     * @return 执行结果
     */
    int insert(MallOrderDto en);

    /**
     * 取消订单
     *
     * @param id id
     * @param cancelOrderReason 取消订单原因
     * @return 执行结果
     */
    int cancelOrder(Long id, String cancelOrderReason);

    /**
     * 确认订单
     *
     * @param id 订单id
     * @return 执行结果
     */
    int confirmOrder(Long id);

    /**
     * 更新自动确认收货时间
     * @param id 订单id
     * @param autoReceiveTime 自动确认收货时间
     * @return 执行结果
     */
    int updateAutoReceiveTime(Long id, Date autoReceiveTime);
}
