package cn.com.duiba.live.clue.service.api.dto.mall.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商城-售后订单表
 *
 * @author kjj mybatis generator
 * 2022-08-09
 */
@Data
public class MallAfterSaleOrderDto implements Serializable {

    private static final long serialVersionUID = -1530905297123233523L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播用户id
     */
    private Long liveUserId;

    /**
     * 商城订单编号
     * tb_mall_order.biz_order_no
     */
    private String bizOrderNo;

    /**
     * 商城订单id
     * tb_mall_order.id
     */
    private Long orderId;

    /**
     * 售后订单号
     */
    private String afterSaleOrderNo;

    /**
     * 售后原因
     */
    private String afterSaleReason;
    
    /**
     * 补充描述
     */
    private String additionalDesc;

    /**
     * 售后类型1-仅退款 2-退货退款
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.MallAfterSaleTypeEnum}
     */
    private Integer afterSaleType;

    /**
     * 售后状态 一个订单只能有一个成功的售后订单 ( status = 已退款 )
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.MallAfterSaleStatusEnum}
     */
    private Integer afterSaleStatus;

    /**
     * 退货单号, 仅当售后类型为退货退款时才需要
     */
    private String expressNum;

    /**
     * 自动关闭退货退款时间
     */
    private Date autoCloseReturnTime;

    /**
     * 售后拒绝原因
     */
    private String afterSaleRejectReason;
}